package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, VolumeId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyVolumeRequest(
    volumeId: VolumeId,
    size: Option[Integer] = None,
    volumeType: Option[zio.aws.ec2.model.VolumeType] = None,
    iops: Option[Integer] = None,
    throughput: Option[Integer] = None,
    multiAttachEnabled: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVolumeRequest = {
    import ModifyVolumeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVolumeRequest
      .builder()
      .volumeId(VolumeId.unwrap(volumeId): java.lang.String)
      .optionallyWith(size.map(value => value: java.lang.Integer))(_.size)
      .optionallyWith(volumeType.map(value => value.unwrap))(_.volumeType)
      .optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops)
      .optionallyWith(throughput.map(value => value: java.lang.Integer))(
        _.throughput
      )
      .optionallyWith(
        multiAttachEnabled.map(value => value: java.lang.Boolean)
      )(_.multiAttachEnabled)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyVolumeRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVolumeRequest.wrap(buildAwsValue())
}
object ModifyVolumeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVolumeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVolumeRequest =
      zio.aws.ec2.model.ModifyVolumeRequest(
        volumeId,
        size.map(value => value),
        volumeType.map(value => value),
        iops.map(value => value),
        throughput.map(value => value),
        multiAttachEnabled.map(value => value)
      )
    def volumeId: VolumeId
    def size: Option[Integer]
    def volumeType: Option[zio.aws.ec2.model.VolumeType]
    def iops: Option[Integer]
    def throughput: Option[Integer]
    def multiAttachEnabled: Option[Boolean]
    def getVolumeId: ZIO[Any, Nothing, VolumeId] = ZIO.succeed(volumeId)
    def getSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("size", size)
    def getVolumeType: ZIO[Any, AwsError, zio.aws.ec2.model.VolumeType] =
      AwsError.unwrapOptionField("volumeType", volumeType)
    def getIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("iops", iops)
    def getThroughput: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("throughput", throughput)
    def getMultiAttachEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("multiAttachEnabled", multiAttachEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVolumeRequest
  ) extends zio.aws.ec2.model.ModifyVolumeRequest.ReadOnly {
    override val volumeId: VolumeId =
      zio.aws.ec2.model.primitives.VolumeId(impl.volumeId())
    override val size: Option[Integer] =
      scala.Option(impl.size()).map(value => value: Integer)
    override val volumeType: Option[zio.aws.ec2.model.VolumeType] = scala
      .Option(impl.volumeType())
      .map(value => zio.aws.ec2.model.VolumeType.wrap(value))
    override val iops: Option[Integer] =
      scala.Option(impl.iops()).map(value => value: Integer)
    override val throughput: Option[Integer] =
      scala.Option(impl.throughput()).map(value => value: Integer)
    override val multiAttachEnabled: Option[Boolean] =
      scala.Option(impl.multiAttachEnabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVolumeRequest
  ): zio.aws.ec2.model.ModifyVolumeRequest.ReadOnly = new Wrapper(impl)
}
