package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait LaunchTemplateHttpTokensState {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateHttpTokensState
}
object LaunchTemplateHttpTokensState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.LaunchTemplateHttpTokensState
  ): zio.aws.ec2.model.LaunchTemplateHttpTokensState = value match {
    case software.amazon.awssdk.services.ec2.model.LaunchTemplateHttpTokensState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.LaunchTemplateHttpTokensState.OPTIONAL =>
      val r = optional
      r
    case software.amazon.awssdk.services.ec2.model.LaunchTemplateHttpTokensState.REQUIRED =>
      val r = required
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.LaunchTemplateHttpTokensState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LaunchTemplateHttpTokensState =
      software.amazon.awssdk.services.ec2.model.LaunchTemplateHttpTokensState.UNKNOWN_TO_SDK_VERSION
  }
  case object optional extends zio.aws.ec2.model.LaunchTemplateHttpTokensState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LaunchTemplateHttpTokensState =
      software.amazon.awssdk.services.ec2.model.LaunchTemplateHttpTokensState.OPTIONAL
  }
  case object required extends zio.aws.ec2.model.LaunchTemplateHttpTokensState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LaunchTemplateHttpTokensState =
      software.amazon.awssdk.services.ec2.model.LaunchTemplateHttpTokensState.REQUIRED
  }
}
