package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait IpamPoolAllocationResourceType {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.IpamPoolAllocationResourceType
}
object IpamPoolAllocationResourceType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.IpamPoolAllocationResourceType
  ): zio.aws.ec2.model.IpamPoolAllocationResourceType = value match {
    case software.amazon.awssdk.services.ec2.model.IpamPoolAllocationResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolAllocationResourceType.IPAM_POOL =>
      val r = `ipam-pool`
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolAllocationResourceType.VPC =>
      val r = vpc
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolAllocationResourceType.EC2_PUBLIC_IPV4_POOL =>
      val r = `ec2-public-ipv4-pool`
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolAllocationResourceType.CUSTOM =>
      val r = custom
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.IpamPoolAllocationResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolAllocationResourceType =
      software.amazon.awssdk.services.ec2.model.IpamPoolAllocationResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object `ipam-pool`
      extends zio.aws.ec2.model.IpamPoolAllocationResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolAllocationResourceType =
      software.amazon.awssdk.services.ec2.model.IpamPoolAllocationResourceType.IPAM_POOL
  }
  case object vpc extends zio.aws.ec2.model.IpamPoolAllocationResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolAllocationResourceType =
      software.amazon.awssdk.services.ec2.model.IpamPoolAllocationResourceType.VPC
  }
  case object `ec2-public-ipv4-pool`
      extends zio.aws.ec2.model.IpamPoolAllocationResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolAllocationResourceType =
      software.amazon.awssdk.services.ec2.model.IpamPoolAllocationResourceType.EC2_PUBLIC_IPV4_POOL
  }
  case object custom extends zio.aws.ec2.model.IpamPoolAllocationResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolAllocationResourceType =
      software.amazon.awssdk.services.ec2.model.IpamPoolAllocationResourceType.CUSTOM
  }
}
