package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceNetworkInterface(
    association: Option[zio.aws.ec2.model.InstanceNetworkInterfaceAssociation] =
      None,
    attachment: Option[zio.aws.ec2.model.InstanceNetworkInterfaceAttachment] =
      None,
    description: Option[String] = None,
    groups: Option[Iterable[zio.aws.ec2.model.GroupIdentifier]] = None,
    ipv6Addresses: Option[Iterable[zio.aws.ec2.model.InstanceIpv6Address]] =
      None,
    macAddress: Option[String] = None,
    networkInterfaceId: Option[String] = None,
    ownerId: Option[String] = None,
    privateDnsName: Option[String] = None,
    privateIpAddress: Option[String] = None,
    privateIpAddresses: Option[
      Iterable[zio.aws.ec2.model.InstancePrivateIpAddress]
    ] = None,
    sourceDestCheck: Option[Boolean] = None,
    status: Option[zio.aws.ec2.model.NetworkInterfaceStatus] = None,
    subnetId: Option[String] = None,
    vpcId: Option[String] = None,
    interfaceType: Option[String] = None,
    ipv4Prefixes: Option[Iterable[zio.aws.ec2.model.InstanceIpv4Prefix]] = None,
    ipv6Prefixes: Option[Iterable[zio.aws.ec2.model.InstanceIpv6Prefix]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceNetworkInterface = {
    import InstanceNetworkInterface.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceNetworkInterface
      .builder()
      .optionallyWith(association.map(value => value.buildAwsValue()))(
        _.association
      )
      .optionallyWith(attachment.map(value => value.buildAwsValue()))(
        _.attachment
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(
        ipv6Addresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Addresses)
      .optionallyWith(macAddress.map(value => value: java.lang.String))(
        _.macAddress
      )
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(privateDnsName.map(value => value: java.lang.String))(
        _.privateDnsName
      )
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .optionallyWith(
        privateIpAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.privateIpAddresses)
      .optionallyWith(sourceDestCheck.map(value => value: java.lang.Boolean))(
        _.sourceDestCheck
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(subnetId.map(value => value: java.lang.String))(
        _.subnetId
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(interfaceType.map(value => value: java.lang.String))(
        _.interfaceType
      )
      .optionallyWith(
        ipv4Prefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv4Prefixes)
      .optionallyWith(
        ipv6Prefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Prefixes)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceNetworkInterface.ReadOnly =
    zio.aws.ec2.model.InstanceNetworkInterface.wrap(buildAwsValue())
}
object InstanceNetworkInterface {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceNetworkInterface
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceNetworkInterface =
      zio.aws.ec2.model.InstanceNetworkInterface(
        association.map(value => value.asEditable),
        attachment.map(value => value.asEditable),
        description.map(value => value),
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipv6Addresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        macAddress.map(value => value),
        networkInterfaceId.map(value => value),
        ownerId.map(value => value),
        privateDnsName.map(value => value),
        privateIpAddress.map(value => value),
        privateIpAddresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceDestCheck.map(value => value),
        status.map(value => value),
        subnetId.map(value => value),
        vpcId.map(value => value),
        interfaceType.map(value => value),
        ipv4Prefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipv6Prefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def association
        : Option[zio.aws.ec2.model.InstanceNetworkInterfaceAssociation.ReadOnly]
    def attachment
        : Option[zio.aws.ec2.model.InstanceNetworkInterfaceAttachment.ReadOnly]
    def description: Option[String]
    def groups: Option[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]]
    def ipv6Addresses
        : Option[List[zio.aws.ec2.model.InstanceIpv6Address.ReadOnly]]
    def macAddress: Option[String]
    def networkInterfaceId: Option[String]
    def ownerId: Option[String]
    def privateDnsName: Option[String]
    def privateIpAddress: Option[String]
    def privateIpAddresses
        : Option[List[zio.aws.ec2.model.InstancePrivateIpAddress.ReadOnly]]
    def sourceDestCheck: Option[Boolean]
    def status: Option[zio.aws.ec2.model.NetworkInterfaceStatus]
    def subnetId: Option[String]
    def vpcId: Option[String]
    def interfaceType: Option[String]
    def ipv4Prefixes
        : Option[List[zio.aws.ec2.model.InstanceIpv4Prefix.ReadOnly]]
    def ipv6Prefixes
        : Option[List[zio.aws.ec2.model.InstanceIpv6Prefix.ReadOnly]]
    def getAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceNetworkInterfaceAssociation.ReadOnly
    ] = AwsError.unwrapOptionField("association", association)
    def getAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceNetworkInterfaceAttachment.ReadOnly
    ] = AwsError.unwrapOptionField("attachment", attachment)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getGroups
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] =
      AwsError.unwrapOptionField("groups", groups)
    def getIpv6Addresses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceIpv6Address.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv6Addresses", ipv6Addresses)
    def getMacAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("macAddress", macAddress)
    def getNetworkInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getPrivateDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateDnsName", privateDnsName)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getPrivateIpAddresses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstancePrivateIpAddress.ReadOnly
    ]] = AwsError.unwrapOptionField("privateIpAddresses", privateIpAddresses)
    def getSourceDestCheck: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("sourceDestCheck", sourceDestCheck)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.NetworkInterfaceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSubnetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getInterfaceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("interfaceType", interfaceType)
    def getIpv4Prefixes: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceIpv4Prefix.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv4Prefixes", ipv4Prefixes)
    def getIpv6Prefixes: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceIpv6Prefix.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv6Prefixes", ipv6Prefixes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceNetworkInterface
  ) extends zio.aws.ec2.model.InstanceNetworkInterface.ReadOnly {
    override val association: Option[
      zio.aws.ec2.model.InstanceNetworkInterfaceAssociation.ReadOnly
    ] = scala
      .Option(impl.association())
      .map(value =>
        zio.aws.ec2.model.InstanceNetworkInterfaceAssociation.wrap(value)
      )
    override val attachment: Option[
      zio.aws.ec2.model.InstanceNetworkInterfaceAttachment.ReadOnly
    ] = scala
      .Option(impl.attachment())
      .map(value =>
        zio.aws.ec2.model.InstanceNetworkInterfaceAttachment.wrap(value)
      )
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val groups
        : Option[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] = scala
      .Option(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.GroupIdentifier.wrap(item)
        }.toList
      )
    override val ipv6Addresses
        : Option[List[zio.aws.ec2.model.InstanceIpv6Address.ReadOnly]] = scala
      .Option(impl.ipv6Addresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceIpv6Address.wrap(item)
        }.toList
      )
    override val macAddress: Option[String] =
      scala.Option(impl.macAddress()).map(value => value: String)
    override val networkInterfaceId: Option[String] =
      scala.Option(impl.networkInterfaceId()).map(value => value: String)
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val privateDnsName: Option[String] =
      scala.Option(impl.privateDnsName()).map(value => value: String)
    override val privateIpAddress: Option[String] =
      scala.Option(impl.privateIpAddress()).map(value => value: String)
    override val privateIpAddresses
        : Option[List[zio.aws.ec2.model.InstancePrivateIpAddress.ReadOnly]] =
      scala
        .Option(impl.privateIpAddresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InstancePrivateIpAddress.wrap(item)
          }.toList
        )
    override val sourceDestCheck: Option[Boolean] =
      scala.Option(impl.sourceDestCheck()).map(value => value: Boolean)
    override val status: Option[zio.aws.ec2.model.NetworkInterfaceStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.ec2.model.NetworkInterfaceStatus.wrap(value))
    override val subnetId: Option[String] =
      scala.Option(impl.subnetId()).map(value => value: String)
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val interfaceType: Option[String] =
      scala.Option(impl.interfaceType()).map(value => value: String)
    override val ipv4Prefixes
        : Option[List[zio.aws.ec2.model.InstanceIpv4Prefix.ReadOnly]] = scala
      .Option(impl.ipv4Prefixes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceIpv4Prefix.wrap(item)
        }.toList
      )
    override val ipv6Prefixes
        : Option[List[zio.aws.ec2.model.InstanceIpv6Prefix.ReadOnly]] = scala
      .Option(impl.ipv6Prefixes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceIpv6Prefix.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceNetworkInterface
  ): zio.aws.ec2.model.InstanceNetworkInterface.ReadOnly = new Wrapper(impl)
}
