package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class IKEVersionsRequestListValue(value: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.IKEVersionsRequestListValue = {
    import IKEVersionsRequestListValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IKEVersionsRequestListValue
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IKEVersionsRequestListValue.ReadOnly =
    zio.aws.ec2.model.IKEVersionsRequestListValue.wrap(buildAwsValue())
}
object IKEVersionsRequestListValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.IKEVersionsRequestListValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IKEVersionsRequestListValue =
      zio.aws.ec2.model.IKEVersionsRequestListValue(value.map(value => value))
    def value: Option[String]
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IKEVersionsRequestListValue
  ) extends zio.aws.ec2.model.IKEVersionsRequestListValue.ReadOnly {
    override val value: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IKEVersionsRequestListValue
  ): zio.aws.ec2.model.IKEVersionsRequestListValue.ReadOnly = new Wrapper(impl)
}
