package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class HistoryRecordEntry(
    eventInformation: Option[zio.aws.ec2.model.EventInformation] = None,
    eventType: Option[zio.aws.ec2.model.FleetEventType] = None,
    timestamp: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.HistoryRecordEntry = {
    import HistoryRecordEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.HistoryRecordEntry
      .builder()
      .optionallyWith(eventInformation.map(value => value.buildAwsValue()))(
        _.eventInformation
      )
      .optionallyWith(eventType.map(value => value.unwrap))(_.eventType)
      .optionallyWith(timestamp.map(value => DateTime.unwrap(value): Instant))(
        _.timestamp
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.HistoryRecordEntry.ReadOnly =
    zio.aws.ec2.model.HistoryRecordEntry.wrap(buildAwsValue())
}
object HistoryRecordEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.HistoryRecordEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.HistoryRecordEntry =
      zio.aws.ec2.model.HistoryRecordEntry(
        eventInformation.map(value => value.asEditable),
        eventType.map(value => value),
        timestamp.map(value => value)
      )
    def eventInformation: Option[zio.aws.ec2.model.EventInformation.ReadOnly]
    def eventType: Option[zio.aws.ec2.model.FleetEventType]
    def timestamp: Option[DateTime]
    def getEventInformation
        : ZIO[Any, AwsError, zio.aws.ec2.model.EventInformation.ReadOnly] =
      AwsError.unwrapOptionField("eventInformation", eventInformation)
    def getEventType: ZIO[Any, AwsError, zio.aws.ec2.model.FleetEventType] =
      AwsError.unwrapOptionField("eventType", eventType)
    def getTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("timestamp", timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.HistoryRecordEntry
  ) extends zio.aws.ec2.model.HistoryRecordEntry.ReadOnly {
    override val eventInformation
        : Option[zio.aws.ec2.model.EventInformation.ReadOnly] = scala
      .Option(impl.eventInformation())
      .map(value => zio.aws.ec2.model.EventInformation.wrap(value))
    override val eventType: Option[zio.aws.ec2.model.FleetEventType] = scala
      .Option(impl.eventType())
      .map(value => zio.aws.ec2.model.FleetEventType.wrap(value))
    override val timestamp: Option[DateTime] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.HistoryRecordEntry
  ): zio.aws.ec2.model.HistoryRecordEntry.ReadOnly = new Wrapper(impl)
}
