package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.TotalGpuMemory
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GpuInfo(
    gpus: Option[Iterable[zio.aws.ec2.model.GpuDeviceInfo]] = None,
    totalGpuMemoryInMiB: Option[TotalGpuMemory] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.GpuInfo = {
    import GpuInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GpuInfo
      .builder()
      .optionallyWith(
        gpus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gpus)
      .optionallyWith(
        totalGpuMemoryInMiB.map(value => TotalGpuMemory.unwrap(value): Integer)
      )(_.totalGpuMemoryInMiB)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GpuInfo.ReadOnly =
    zio.aws.ec2.model.GpuInfo.wrap(buildAwsValue())
}
object GpuInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.GpuInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GpuInfo = zio.aws.ec2.model.GpuInfo(
      gpus.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      totalGpuMemoryInMiB.map(value => value)
    )
    def gpus: Option[List[zio.aws.ec2.model.GpuDeviceInfo.ReadOnly]]
    def totalGpuMemoryInMiB: Option[TotalGpuMemory]
    def getGpus
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.GpuDeviceInfo.ReadOnly]] =
      AwsError.unwrapOptionField("gpus", gpus)
    def getTotalGpuMemoryInMiB: ZIO[Any, AwsError, TotalGpuMemory] =
      AwsError.unwrapOptionField("totalGpuMemoryInMiB", totalGpuMemoryInMiB)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GpuInfo
  ) extends zio.aws.ec2.model.GpuInfo.ReadOnly {
    override val gpus: Option[List[zio.aws.ec2.model.GpuDeviceInfo.ReadOnly]] =
      scala
        .Option(impl.gpus())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.GpuDeviceInfo.wrap(item)
          }.toList
        )
    override val totalGpuMemoryInMiB: Option[TotalGpuMemory] = scala
      .Option(impl.totalGpuMemoryInMiB())
      .map(value => zio.aws.ec2.model.primitives.TotalGpuMemory(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GpuInfo
  ): zio.aws.ec2.model.GpuInfo.ReadOnly = new Wrapper(impl)
}
