package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetLaunchTemplateDataRequest(instanceId: InstanceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataRequest = {
    import GetLaunchTemplateDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetLaunchTemplateDataRequest.ReadOnly =
    zio.aws.ec2.model.GetLaunchTemplateDataRequest.wrap(buildAwsValue())
}
object GetLaunchTemplateDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetLaunchTemplateDataRequest =
      zio.aws.ec2.model.GetLaunchTemplateDataRequest(instanceId)
    def instanceId: InstanceId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataRequest
  ) extends zio.aws.ec2.model.GetLaunchTemplateDataRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataRequest
  ): zio.aws.ec2.model.GetLaunchTemplateDataRequest.ReadOnly = new Wrapper(impl)
}
