package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  Ipv6PoolMaxResults,
  NextToken,
  Ipv6PoolEc2Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetAssociatedIpv6PoolCidrsRequest(
    poolId: Ipv6PoolEc2Id,
    nextToken: Option[NextToken] = None,
    maxResults: Option[Ipv6PoolMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsRequest = {
    import GetAssociatedIpv6PoolCidrsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsRequest
      .builder()
      .poolId(Ipv6PoolEc2Id.unwrap(poolId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => Ipv6PoolMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsRequest.ReadOnly =
    zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsRequest.wrap(buildAwsValue())
}
object GetAssociatedIpv6PoolCidrsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsRequest =
      zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsRequest(
        poolId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def poolId: Ipv6PoolEc2Id
    def nextToken: Option[NextToken]
    def maxResults: Option[Ipv6PoolMaxResults]
    def getPoolId: ZIO[Any, Nothing, Ipv6PoolEc2Id] = ZIO.succeed(poolId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Ipv6PoolMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsRequest
  ) extends zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsRequest.ReadOnly {
    override val poolId: Ipv6PoolEc2Id =
      zio.aws.ec2.model.primitives.Ipv6PoolEc2Id(impl.poolId())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val maxResults: Option[Ipv6PoolMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.Ipv6PoolMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsRequest
  ): zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsRequest.ReadOnly = new Wrapper(
    impl
  )
}
