package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait EventType {
  def unwrap: software.amazon.awssdk.services.ec2.model.EventType
}
object EventType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.EventType
  ): zio.aws.ec2.model.EventType = value match {
    case software.amazon.awssdk.services.ec2.model.EventType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.EventType.INSTANCE_CHANGE =>
      val r = instanceChange
      r
    case software.amazon.awssdk.services.ec2.model.EventType.FLEET_REQUEST_CHANGE =>
      val r = fleetRequestChange
      r
    case software.amazon.awssdk.services.ec2.model.EventType.ERROR =>
      val r = error
      r
    case software.amazon.awssdk.services.ec2.model.EventType.INFORMATION =>
      val r = information
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.EventType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.EventType =
      software.amazon.awssdk.services.ec2.model.EventType.UNKNOWN_TO_SDK_VERSION
  }
  case object instanceChange extends zio.aws.ec2.model.EventType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.EventType =
      software.amazon.awssdk.services.ec2.model.EventType.INSTANCE_CHANGE
  }
  case object fleetRequestChange extends zio.aws.ec2.model.EventType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.EventType =
      software.amazon.awssdk.services.ec2.model.EventType.FLEET_REQUEST_CHANGE
  }
  case object error extends zio.aws.ec2.model.EventType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.EventType =
      software.amazon.awssdk.services.ec2.model.EventType.ERROR
  }
  case object information extends zio.aws.ec2.model.EventType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.EventType =
      software.amazon.awssdk.services.ec2.model.EventType.INFORMATION
  }
}
