package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpnGatewayId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeVpnGatewaysRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    vpnGatewayIds: Option[Iterable[VpnGatewayId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysRequest = {
    import DescribeVpnGatewaysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        vpnGatewayIds.map(value =>
          value.map { item =>
            VpnGatewayId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.vpnGatewayIds)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeVpnGatewaysRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVpnGatewaysRequest.wrap(buildAwsValue())
}
object DescribeVpnGatewaysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVpnGatewaysRequest =
      zio.aws.ec2.model.DescribeVpnGatewaysRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpnGatewayIds.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def vpnGatewayIds: Option[List[VpnGatewayId]]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getVpnGatewayIds: ZIO[Any, AwsError, List[VpnGatewayId]] =
      AwsError.unwrapOptionField("vpnGatewayIds", vpnGatewayIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysRequest
  ) extends zio.aws.ec2.model.DescribeVpnGatewaysRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val vpnGatewayIds: Option[List[VpnGatewayId]] = scala
      .Option(impl.vpnGatewayIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.VpnGatewayId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysRequest
  ): zio.aws.ec2.model.DescribeVpnGatewaysRequest.ReadOnly = new Wrapper(impl)
}
