package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeLocalGatewayRouteTablesResponse(
    localGatewayRouteTables: Option[
      Iterable[zio.aws.ec2.model.LocalGatewayRouteTable]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesResponse = {
    import DescribeLocalGatewayRouteTablesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesResponse
      .builder()
      .optionallyWith(
        localGatewayRouteTables.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.localGatewayRouteTables)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeLocalGatewayRouteTablesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeLocalGatewayRouteTablesResponse
      .wrap(buildAwsValue())
}
object DescribeLocalGatewayRouteTablesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeLocalGatewayRouteTablesResponse =
      zio.aws.ec2.model.DescribeLocalGatewayRouteTablesResponse(
        localGatewayRouteTables.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def localGatewayRouteTables
        : Option[List[zio.aws.ec2.model.LocalGatewayRouteTable.ReadOnly]]
    def nextToken: Option[String]
    def getLocalGatewayRouteTables: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LocalGatewayRouteTable.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "localGatewayRouteTables",
      localGatewayRouteTables
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesResponse
  ) extends zio.aws.ec2.model.DescribeLocalGatewayRouteTablesResponse.ReadOnly {
    override val localGatewayRouteTables
        : Option[List[zio.aws.ec2.model.LocalGatewayRouteTable.ReadOnly]] =
      scala
        .Option(impl.localGatewayRouteTables())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.LocalGatewayRouteTable.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesResponse
  ): zio.aws.ec2.model.DescribeLocalGatewayRouteTablesResponse.ReadOnly =
    new Wrapper(impl)
}
