package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{NextToken, DITMaxResults}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeInstanceTypesRequest(
    instanceTypes: Option[Iterable[zio.aws.ec2.model.InstanceType]] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[DITMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesRequest = {
    import DescribeInstanceTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesRequest
      .builder()
      .optionallyWith(
        instanceTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.instanceTypesWithStrings)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => DITMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeInstanceTypesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeInstanceTypesRequest.wrap(buildAwsValue())
}
object DescribeInstanceTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeInstanceTypesRequest =
      zio.aws.ec2.model.DescribeInstanceTypesRequest(
        instanceTypes.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def instanceTypes: Option[List[zio.aws.ec2.model.InstanceType]]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[DITMaxResults]
    def nextToken: Option[NextToken]
    def getInstanceTypes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.InstanceType]] =
      AwsError.unwrapOptionField("instanceTypes", instanceTypes)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, DITMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesRequest
  ) extends zio.aws.ec2.model.DescribeInstanceTypesRequest.ReadOnly {
    override val instanceTypes: Option[List[zio.aws.ec2.model.InstanceType]] =
      scala
        .Option(impl.instanceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InstanceType.wrap(item)
          }.toList
        )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[DITMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.DITMaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesRequest
  ): zio.aws.ec2.model.DescribeInstanceTypesRequest.ReadOnly = new Wrapper(impl)
}
