package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeHostsResponse(
    hosts: Option[Iterable[zio.aws.ec2.model.Host]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeHostsResponse = {
    import DescribeHostsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeHostsResponse
      .builder()
      .optionallyWith(
        hosts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hosts)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeHostsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeHostsResponse.wrap(buildAwsValue())
}
object DescribeHostsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeHostsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeHostsResponse =
      zio.aws.ec2.model.DescribeHostsResponse(
        hosts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def hosts: Option[List[zio.aws.ec2.model.Host.ReadOnly]]
    def nextToken: Option[String]
    def getHosts: ZIO[Any, AwsError, List[zio.aws.ec2.model.Host.ReadOnly]] =
      AwsError.unwrapOptionField("hosts", hosts)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeHostsResponse
  ) extends zio.aws.ec2.model.DescribeHostsResponse.ReadOnly {
    override val hosts: Option[List[zio.aws.ec2.model.Host.ReadOnly]] = scala
      .Option(impl.hosts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Host.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeHostsResponse
  ): zio.aws.ec2.model.DescribeHostsResponse.ReadOnly = new Wrapper(impl)
}
