package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, VpcFlowLogId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeFlowLogsRequest(
    filter: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    flowLogIds: Option[Iterable[VpcFlowLogId]] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeFlowLogsRequest = {
    import DescribeFlowLogsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeFlowLogsRequest
      .builder()
      .optionallyWith(
        filter.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filter)
      .optionallyWith(
        flowLogIds.map(value =>
          value.map { item =>
            VpcFlowLogId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.flowLogIds)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeFlowLogsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeFlowLogsRequest.wrap(buildAwsValue())
}
object DescribeFlowLogsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeFlowLogsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeFlowLogsRequest =
      zio.aws.ec2.model.DescribeFlowLogsRequest(
        filter.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        flowLogIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filter: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def flowLogIds: Option[List[VpcFlowLogId]]
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def getFilter: ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filter", filter)
    def getFlowLogIds: ZIO[Any, AwsError, List[VpcFlowLogId]] =
      AwsError.unwrapOptionField("flowLogIds", flowLogIds)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFlowLogsRequest
  ) extends zio.aws.ec2.model.DescribeFlowLogsRequest.ReadOnly {
    override val filter: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] = scala
      .Option(impl.filter())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Filter.wrap(item)
        }.toList
      )
    override val flowLogIds: Option[List[VpcFlowLogId]] = scala
      .Option(impl.flowLogIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.VpcFlowLogId(item)
        }.toList
      )
    override val maxResults: Option[Integer] =
      scala.Option(impl.maxResults()).map(value => value: Integer)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFlowLogsRequest
  ): zio.aws.ec2.model.DescribeFlowLogsRequest.ReadOnly = new Wrapper(impl)
}
