package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  NextToken,
  DescribeFastLaunchImagesRequestMaxResults,
  ImageId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeFastLaunchImagesRequest(
    imageIds: Option[Iterable[ImageId]] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[DescribeFastLaunchImagesRequestMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesRequest = {
    import DescribeFastLaunchImagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesRequest
      .builder()
      .optionallyWith(
        imageIds.map(value =>
          value.map { item =>
            ImageId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.imageIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          DescribeFastLaunchImagesRequestMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeFastLaunchImagesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeFastLaunchImagesRequest.wrap(buildAwsValue())
}
object DescribeFastLaunchImagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeFastLaunchImagesRequest =
      zio.aws.ec2.model.DescribeFastLaunchImagesRequest(
        imageIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def imageIds: Option[List[ImageId]]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[DescribeFastLaunchImagesRequestMaxResults]
    def nextToken: Option[NextToken]
    def getImageIds: ZIO[Any, AwsError, List[ImageId]] =
      AwsError.unwrapOptionField("imageIds", imageIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeFastLaunchImagesRequestMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesRequest
  ) extends zio.aws.ec2.model.DescribeFastLaunchImagesRequest.ReadOnly {
    override val imageIds: Option[List[ImageId]] = scala
      .Option(impl.imageIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.ImageId(item)
        }.toList
      )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[DescribeFastLaunchImagesRequestMaxResults] =
      scala
        .Option(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeFastLaunchImagesRequestMaxResults(value)
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesRequest
  ): zio.aws.ec2.model.DescribeFastLaunchImagesRequest.ReadOnly = new Wrapper(
    impl
  )
}
