package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  DescribeEgressOnlyInternetGatewaysMaxResults,
  EgressOnlyInternetGatewayId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeEgressOnlyInternetGatewaysRequest(
    egressOnlyInternetGatewayIds: Option[
      Iterable[EgressOnlyInternetGatewayId]
    ] = None,
    maxResults: Option[DescribeEgressOnlyInternetGatewaysMaxResults] = None,
    nextToken: Option[String] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysRequest = {
    import DescribeEgressOnlyInternetGatewaysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysRequest
      .builder()
      .optionallyWith(
        egressOnlyInternetGatewayIds.map(value =>
          value.map { item =>
            EgressOnlyInternetGatewayId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.egressOnlyInternetGatewayIds)
      .optionallyWith(
        maxResults.map(value =>
          DescribeEgressOnlyInternetGatewaysMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysRequest.ReadOnly =
    zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysRequest
      .wrap(buildAwsValue())
}
object DescribeEgressOnlyInternetGatewaysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysRequest =
      zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysRequest(
        egressOnlyInternetGatewayIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def egressOnlyInternetGatewayIds: Option[List[EgressOnlyInternetGatewayId]]
    def maxResults: Option[DescribeEgressOnlyInternetGatewaysMaxResults]
    def nextToken: Option[String]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def getEgressOnlyInternetGatewayIds
        : ZIO[Any, AwsError, List[EgressOnlyInternetGatewayId]] =
      AwsError.unwrapOptionField(
        "egressOnlyInternetGatewayIds",
        egressOnlyInternetGatewayIds
      )
    def getMaxResults
        : ZIO[Any, AwsError, DescribeEgressOnlyInternetGatewaysMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysRequest
  ) extends zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysRequest.ReadOnly {
    override val egressOnlyInternetGatewayIds
        : Option[List[EgressOnlyInternetGatewayId]] = scala
      .Option(impl.egressOnlyInternetGatewayIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.EgressOnlyInternetGatewayId(item)
        }.toList
      )
    override val maxResults
        : Option[DescribeEgressOnlyInternetGatewaysMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives
          .DescribeEgressOnlyInternetGatewaysMaxResults(value)
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysRequest
  ): zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysRequest.ReadOnly =
    new Wrapper(impl)
}
