package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, FlowLogResourceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateFlowLogsRequest(
    clientToken: Option[String] = None,
    deliverLogsPermissionArn: Option[String] = None,
    logGroupName: Option[String] = None,
    resourceIds: Iterable[FlowLogResourceId],
    resourceType: zio.aws.ec2.model.FlowLogsResourceType,
    trafficType: zio.aws.ec2.model.TrafficType,
    logDestinationType: Option[zio.aws.ec2.model.LogDestinationType] = None,
    logDestination: Option[String] = None,
    logFormat: Option[String] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None,
    maxAggregationInterval: Option[Integer] = None,
    destinationOptions: Option[zio.aws.ec2.model.DestinationOptionsRequest] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateFlowLogsRequest = {
    import CreateFlowLogsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateFlowLogsRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        deliverLogsPermissionArn.map(value => value: java.lang.String)
      )(_.deliverLogsPermissionArn)
      .optionallyWith(logGroupName.map(value => value: java.lang.String))(
        _.logGroupName
      )
      .resourceIds(resourceIds.map { item =>
        FlowLogResourceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .resourceType(resourceType.unwrap)
      .trafficType(trafficType.unwrap)
      .optionallyWith(logDestinationType.map(value => value.unwrap))(
        _.logDestinationType
      )
      .optionallyWith(logDestination.map(value => value: java.lang.String))(
        _.logDestination
      )
      .optionallyWith(logFormat.map(value => value: java.lang.String))(
        _.logFormat
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(
        maxAggregationInterval.map(value => value: java.lang.Integer)
      )(_.maxAggregationInterval)
      .optionallyWith(destinationOptions.map(value => value.buildAwsValue()))(
        _.destinationOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateFlowLogsRequest.ReadOnly =
    zio.aws.ec2.model.CreateFlowLogsRequest.wrap(buildAwsValue())
}
object CreateFlowLogsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateFlowLogsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateFlowLogsRequest =
      zio.aws.ec2.model.CreateFlowLogsRequest(
        clientToken.map(value => value),
        deliverLogsPermissionArn.map(value => value),
        logGroupName.map(value => value),
        resourceIds,
        resourceType,
        trafficType,
        logDestinationType.map(value => value),
        logDestination.map(value => value),
        logFormat.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxAggregationInterval.map(value => value),
        destinationOptions.map(value => value.asEditable)
      )
    def clientToken: Option[String]
    def deliverLogsPermissionArn: Option[String]
    def logGroupName: Option[String]
    def resourceIds: List[FlowLogResourceId]
    def resourceType: zio.aws.ec2.model.FlowLogsResourceType
    def trafficType: zio.aws.ec2.model.TrafficType
    def logDestinationType: Option[zio.aws.ec2.model.LogDestinationType]
    def logDestination: Option[String]
    def logFormat: Option[String]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def maxAggregationInterval: Option[Integer]
    def destinationOptions
        : Option[zio.aws.ec2.model.DestinationOptionsRequest.ReadOnly]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDeliverLogsPermissionArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("deliverLogsPermissionArn", deliverLogsPermissionArn)
    def getLogGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logGroupName", logGroupName)
    def getResourceIds: ZIO[Any, Nothing, List[FlowLogResourceId]] =
      ZIO.succeed(resourceIds)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.ec2.model.FlowLogsResourceType] =
      ZIO.succeed(resourceType)
    def getTrafficType: ZIO[Any, Nothing, zio.aws.ec2.model.TrafficType] =
      ZIO.succeed(trafficType)
    def getLogDestinationType
        : ZIO[Any, AwsError, zio.aws.ec2.model.LogDestinationType] =
      AwsError.unwrapOptionField("logDestinationType", logDestinationType)
    def getLogDestination: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logDestination", logDestination)
    def getLogFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logFormat", logFormat)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getMaxAggregationInterval: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("maxAggregationInterval", maxAggregationInterval)
    def getDestinationOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.DestinationOptionsRequest.ReadOnly
    ] = AwsError.unwrapOptionField("destinationOptions", destinationOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateFlowLogsRequest
  ) extends zio.aws.ec2.model.CreateFlowLogsRequest.ReadOnly {
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val deliverLogsPermissionArn: Option[String] =
      scala.Option(impl.deliverLogsPermissionArn()).map(value => value: String)
    override val logGroupName: Option[String] =
      scala.Option(impl.logGroupName()).map(value => value: String)
    override val resourceIds: List[FlowLogResourceId] = impl
      .resourceIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.FlowLogResourceId(item)
      }
      .toList
    override val resourceType: zio.aws.ec2.model.FlowLogsResourceType =
      zio.aws.ec2.model.FlowLogsResourceType.wrap(impl.resourceType())
    override val trafficType: zio.aws.ec2.model.TrafficType =
      zio.aws.ec2.model.TrafficType.wrap(impl.trafficType())
    override val logDestinationType
        : Option[zio.aws.ec2.model.LogDestinationType] = scala
      .Option(impl.logDestinationType())
      .map(value => zio.aws.ec2.model.LogDestinationType.wrap(value))
    override val logDestination: Option[String] =
      scala.Option(impl.logDestination()).map(value => value: String)
    override val logFormat: Option[String] =
      scala.Option(impl.logFormat()).map(value => value: String)
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
    override val maxAggregationInterval: Option[Integer] =
      scala.Option(impl.maxAggregationInterval()).map(value => value: Integer)
    override val destinationOptions
        : Option[zio.aws.ec2.model.DestinationOptionsRequest.ReadOnly] = scala
      .Option(impl.destinationOptions())
      .map(value => zio.aws.ec2.model.DestinationOptionsRequest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateFlowLogsRequest
  ): zio.aws.ec2.model.CreateFlowLogsRequest.ReadOnly = new Wrapper(impl)
}
