package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ImportTaskId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CancelImportTaskRequest(
    cancelReason: Option[String] = None,
    importTaskId: Option[ImportTaskId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelImportTaskRequest = {
    import CancelImportTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelImportTaskRequest
      .builder()
      .optionallyWith(cancelReason.map(value => value: java.lang.String))(
        _.cancelReason
      )
      .optionallyWith(
        importTaskId.map(value => ImportTaskId.unwrap(value): java.lang.String)
      )(_.importTaskId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CancelImportTaskRequest.ReadOnly =
    zio.aws.ec2.model.CancelImportTaskRequest.wrap(buildAwsValue())
}
object CancelImportTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelImportTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelImportTaskRequest =
      zio.aws.ec2.model.CancelImportTaskRequest(
        cancelReason.map(value => value),
        importTaskId.map(value => value)
      )
    def cancelReason: Option[String]
    def importTaskId: Option[ImportTaskId]
    def getCancelReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cancelReason", cancelReason)
    def getImportTaskId: ZIO[Any, AwsError, ImportTaskId] =
      AwsError.unwrapOptionField("importTaskId", importTaskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelImportTaskRequest
  ) extends zio.aws.ec2.model.CancelImportTaskRequest.ReadOnly {
    override val cancelReason: Option[String] =
      scala.Option(impl.cancelReason()).map(value => value: String)
    override val importTaskId: Option[ImportTaskId] = scala
      .Option(impl.importTaskId())
      .map(value => zio.aws.ec2.model.primitives.ImportTaskId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelImportTaskRequest
  ): zio.aws.ec2.model.CancelImportTaskRequest.ReadOnly = new Wrapper(impl)
}
