package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AuthorizationRule(
    clientVpnEndpointId: Option[String] = None,
    description: Option[String] = None,
    groupId: Option[String] = None,
    accessAll: Option[Boolean] = None,
    destinationCidr: Option[String] = None,
    status: Option[zio.aws.ec2.model.ClientVpnAuthorizationRuleStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AuthorizationRule = {
    import AuthorizationRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AuthorizationRule
      .builder()
      .optionallyWith(
        clientVpnEndpointId.map(value => value: java.lang.String)
      )(_.clientVpnEndpointId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(groupId.map(value => value: java.lang.String))(_.groupId)
      .optionallyWith(accessAll.map(value => value: java.lang.Boolean))(
        _.accessAll
      )
      .optionallyWith(destinationCidr.map(value => value: java.lang.String))(
        _.destinationCidr
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AuthorizationRule.ReadOnly =
    zio.aws.ec2.model.AuthorizationRule.wrap(buildAwsValue())
}
object AuthorizationRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AuthorizationRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AuthorizationRule =
      zio.aws.ec2.model.AuthorizationRule(
        clientVpnEndpointId.map(value => value),
        description.map(value => value),
        groupId.map(value => value),
        accessAll.map(value => value),
        destinationCidr.map(value => value),
        status.map(value => value.asEditable)
      )
    def clientVpnEndpointId: Option[String]
    def description: Option[String]
    def groupId: Option[String]
    def accessAll: Option[Boolean]
    def destinationCidr: Option[String]
    def status
        : Option[zio.aws.ec2.model.ClientVpnAuthorizationRuleStatus.ReadOnly]
    def getClientVpnEndpointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientVpnEndpointId", clientVpnEndpointId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getAccessAll: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("accessAll", accessAll)
    def getDestinationCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationCidr", destinationCidr)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ClientVpnAuthorizationRuleStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AuthorizationRule
  ) extends zio.aws.ec2.model.AuthorizationRule.ReadOnly {
    override val clientVpnEndpointId: Option[String] =
      scala.Option(impl.clientVpnEndpointId()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val groupId: Option[String] =
      scala.Option(impl.groupId()).map(value => value: String)
    override val accessAll: Option[Boolean] =
      scala.Option(impl.accessAll()).map(value => value: Boolean)
    override val destinationCidr: Option[String] =
      scala.Option(impl.destinationCidr()).map(value => value: String)
    override val status
        : Option[zio.aws.ec2.model.ClientVpnAuthorizationRuleStatus.ReadOnly] =
      scala
        .Option(impl.status())
        .map(value =>
          zio.aws.ec2.model.ClientVpnAuthorizationRuleStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AuthorizationRule
  ): zio.aws.ec2.model.AuthorizationRule.ReadOnly = new Wrapper(impl)
}
