package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait VpcState {
  def unwrap: software.amazon.awssdk.services.ec2.model.VpcState
}
object VpcState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.VpcState
  ): zio.aws.ec2.model.VpcState = value match {
    case software.amazon.awssdk.services.ec2.model.VpcState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.VpcState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.VpcState.AVAILABLE =>
      val r = available
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.VpcState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VpcState =
      software.amazon.awssdk.services.ec2.model.VpcState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending extends zio.aws.ec2.model.VpcState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VpcState =
      software.amazon.awssdk.services.ec2.model.VpcState.PENDING
  }
  case object available extends zio.aws.ec2.model.VpcState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VpcState =
      software.amazon.awssdk.services.ec2.model.VpcState.AVAILABLE
  }
}
