package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  PrefixListResourceId,
  TransitGatewayRouteTableId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TransitGatewayPrefixListReference(
    transitGatewayRouteTableId: Option[TransitGatewayRouteTableId] = None,
    prefixListId: Option[PrefixListResourceId] = None,
    prefixListOwnerId: Option[String] = None,
    state: Option[zio.aws.ec2.model.TransitGatewayPrefixListReferenceState] =
      None,
    blackhole: Option[Boolean] = None,
    transitGatewayAttachment: Option[
      zio.aws.ec2.model.TransitGatewayPrefixListAttachment
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReference = {
    import TransitGatewayPrefixListReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReference
      .builder()
      .optionallyWith(
        transitGatewayRouteTableId.map(value =>
          TransitGatewayRouteTableId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayRouteTableId)
      .optionallyWith(
        prefixListId.map(value =>
          PrefixListResourceId.unwrap(value): java.lang.String
        )
      )(_.prefixListId)
      .optionallyWith(prefixListOwnerId.map(value => value: java.lang.String))(
        _.prefixListOwnerId
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(blackhole.map(value => value: java.lang.Boolean))(
        _.blackhole
      )
      .optionallyWith(
        transitGatewayAttachment.map(value => value.buildAwsValue())
      )(_.transitGatewayAttachment)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayPrefixListReference.ReadOnly =
    zio.aws.ec2.model.TransitGatewayPrefixListReference.wrap(buildAwsValue())
}
object TransitGatewayPrefixListReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayPrefixListReference =
      zio.aws.ec2.model.TransitGatewayPrefixListReference(
        transitGatewayRouteTableId.map(value => value),
        prefixListId.map(value => value),
        prefixListOwnerId.map(value => value),
        state.map(value => value),
        blackhole.map(value => value),
        transitGatewayAttachment.map(value => value.asEditable)
      )
    def transitGatewayRouteTableId: Option[TransitGatewayRouteTableId]
    def prefixListId: Option[PrefixListResourceId]
    def prefixListOwnerId: Option[String]
    def state: Option[zio.aws.ec2.model.TransitGatewayPrefixListReferenceState]
    def blackhole: Option[Boolean]
    def transitGatewayAttachment
        : Option[zio.aws.ec2.model.TransitGatewayPrefixListAttachment.ReadOnly]
    def getTransitGatewayRouteTableId
        : ZIO[Any, AwsError, TransitGatewayRouteTableId] =
      AwsError.unwrapOptionField(
        "transitGatewayRouteTableId",
        transitGatewayRouteTableId
      )
    def getPrefixListId: ZIO[Any, AwsError, PrefixListResourceId] =
      AwsError.unwrapOptionField("prefixListId", prefixListId)
    def getPrefixListOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefixListOwnerId", prefixListOwnerId)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayPrefixListReferenceState
    ] = AwsError.unwrapOptionField("state", state)
    def getBlackhole: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("blackhole", blackhole)
    def getTransitGatewayAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayPrefixListAttachment.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayAttachment",
      transitGatewayAttachment
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReference
  ) extends zio.aws.ec2.model.TransitGatewayPrefixListReference.ReadOnly {
    override val transitGatewayRouteTableId
        : Option[TransitGatewayRouteTableId] = scala
      .Option(impl.transitGatewayRouteTableId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayRouteTableId(value)
      )
    override val prefixListId: Option[PrefixListResourceId] = scala
      .Option(impl.prefixListId())
      .map(value => zio.aws.ec2.model.primitives.PrefixListResourceId(value))
    override val prefixListOwnerId: Option[String] =
      scala.Option(impl.prefixListOwnerId()).map(value => value: String)
    override val state
        : Option[zio.aws.ec2.model.TransitGatewayPrefixListReferenceState] =
      scala
        .Option(impl.state())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayPrefixListReferenceState.wrap(value)
        )
    override val blackhole: Option[Boolean] =
      scala.Option(impl.blackhole()).map(value => value: Boolean)
    override val transitGatewayAttachment: Option[
      zio.aws.ec2.model.TransitGatewayPrefixListAttachment.ReadOnly
    ] = scala
      .Option(impl.transitGatewayAttachment())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayPrefixListAttachment.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReference
  ): zio.aws.ec2.model.TransitGatewayPrefixListReference.ReadOnly = new Wrapper(
    impl
  )
}
