package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class SlotStartTimeRangeRequest(
    earliestTime: Option[DateTime] = None,
    latestTime: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SlotStartTimeRangeRequest = {
    import SlotStartTimeRangeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SlotStartTimeRangeRequest
      .builder()
      .optionallyWith(
        earliestTime.map(value => DateTime.unwrap(value): Instant)
      )(_.earliestTime)
      .optionallyWith(latestTime.map(value => DateTime.unwrap(value): Instant))(
        _.latestTime
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SlotStartTimeRangeRequest.ReadOnly =
    zio.aws.ec2.model.SlotStartTimeRangeRequest.wrap(buildAwsValue())
}
object SlotStartTimeRangeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SlotStartTimeRangeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SlotStartTimeRangeRequest =
      zio.aws.ec2.model.SlotStartTimeRangeRequest(
        earliestTime.map(value => value),
        latestTime.map(value => value)
      )
    def earliestTime: Option[DateTime]
    def latestTime: Option[DateTime]
    def getEarliestTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("earliestTime", earliestTime)
    def getLatestTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("latestTime", latestTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SlotStartTimeRangeRequest
  ) extends zio.aws.ec2.model.SlotStartTimeRangeRequest.ReadOnly {
    override val earliestTime: Option[DateTime] = scala
      .Option(impl.earliestTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val latestTime: Option[DateTime] = scala
      .Option(impl.latestTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SlotStartTimeRangeRequest
  ): zio.aws.ec2.model.SlotStartTimeRangeRequest.ReadOnly = new Wrapper(impl)
}
