package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ScheduledInstanceRecurrenceRequest(
    frequency: Option[String] = None,
    interval: Option[Integer] = None,
    occurrenceDays: Option[Iterable[Integer]] = None,
    occurrenceRelativeToEnd: Option[Boolean] = None,
    occurrenceUnit: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ScheduledInstanceRecurrenceRequest = {
    import ScheduledInstanceRecurrenceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ScheduledInstanceRecurrenceRequest
      .builder()
      .optionallyWith(frequency.map(value => value: java.lang.String))(
        _.frequency
      )
      .optionallyWith(interval.map(value => value: java.lang.Integer))(
        _.interval
      )
      .optionallyWith(
        occurrenceDays.map(value =>
          value.map { item =>
            item: java.lang.Integer
          }.asJavaCollection
        )
      )(_.occurrenceDays)
      .optionallyWith(
        occurrenceRelativeToEnd.map(value => value: java.lang.Boolean)
      )(_.occurrenceRelativeToEnd)
      .optionallyWith(occurrenceUnit.map(value => value: java.lang.String))(
        _.occurrenceUnit
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ScheduledInstanceRecurrenceRequest.ReadOnly =
    zio.aws.ec2.model.ScheduledInstanceRecurrenceRequest.wrap(buildAwsValue())
}
object ScheduledInstanceRecurrenceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ScheduledInstanceRecurrenceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ScheduledInstanceRecurrenceRequest =
      zio.aws.ec2.model.ScheduledInstanceRecurrenceRequest(
        frequency.map(value => value),
        interval.map(value => value),
        occurrenceDays.map(value => value),
        occurrenceRelativeToEnd.map(value => value),
        occurrenceUnit.map(value => value)
      )
    def frequency: Option[String]
    def interval: Option[Integer]
    def occurrenceDays: Option[List[Integer]]
    def occurrenceRelativeToEnd: Option[Boolean]
    def occurrenceUnit: Option[String]
    def getFrequency: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("frequency", frequency)
    def getInterval: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("interval", interval)
    def getOccurrenceDays: ZIO[Any, AwsError, List[Integer]] =
      AwsError.unwrapOptionField("occurrenceDays", occurrenceDays)
    def getOccurrenceRelativeToEnd: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("occurrenceRelativeToEnd", occurrenceRelativeToEnd)
    def getOccurrenceUnit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("occurrenceUnit", occurrenceUnit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstanceRecurrenceRequest
  ) extends zio.aws.ec2.model.ScheduledInstanceRecurrenceRequest.ReadOnly {
    override val frequency: Option[String] =
      scala.Option(impl.frequency()).map(value => value: String)
    override val interval: Option[Integer] =
      scala.Option(impl.interval()).map(value => value: Integer)
    override val occurrenceDays: Option[List[Integer]] = scala
      .Option(impl.occurrenceDays())
      .map(value =>
        value.asScala.map { item =>
          item: Integer
        }.toList
      )
    override val occurrenceRelativeToEnd: Option[Boolean] =
      scala.Option(impl.occurrenceRelativeToEnd()).map(value => value: Boolean)
    override val occurrenceUnit: Option[String] =
      scala.Option(impl.occurrenceUnit()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstanceRecurrenceRequest
  ): zio.aws.ec2.model.ScheduledInstanceRecurrenceRequest.ReadOnly =
    new Wrapper(impl)
}
