package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Phase1IntegrityAlgorithmsRequestListValue(
    value: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.Phase1IntegrityAlgorithmsRequestListValue = {
    import Phase1IntegrityAlgorithmsRequestListValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Phase1IntegrityAlgorithmsRequestListValue
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.Phase1IntegrityAlgorithmsRequestListValue.ReadOnly =
    zio.aws.ec2.model.Phase1IntegrityAlgorithmsRequestListValue
      .wrap(buildAwsValue())
}
object Phase1IntegrityAlgorithmsRequestListValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.Phase1IntegrityAlgorithmsRequestListValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.Phase1IntegrityAlgorithmsRequestListValue =
      zio.aws.ec2.model
        .Phase1IntegrityAlgorithmsRequestListValue(value.map(value => value))
    def value: Option[String]
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Phase1IntegrityAlgorithmsRequestListValue
  ) extends zio.aws.ec2.model.Phase1IntegrityAlgorithmsRequestListValue.ReadOnly {
    override val value: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Phase1IntegrityAlgorithmsRequestListValue
  ): zio.aws.ec2.model.Phase1IntegrityAlgorithmsRequestListValue.ReadOnly =
    new Wrapper(impl)
}
