package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListImagesInRecycleBinResponse(
    images: Option[Iterable[zio.aws.ec2.model.ImageRecycleBinInfo]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinResponse = {
    import ListImagesInRecycleBinResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinResponse
      .builder()
      .optionallyWith(
        images.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.images)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ListImagesInRecycleBinResponse.ReadOnly =
    zio.aws.ec2.model.ListImagesInRecycleBinResponse.wrap(buildAwsValue())
}
object ListImagesInRecycleBinResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ListImagesInRecycleBinResponse =
      zio.aws.ec2.model.ListImagesInRecycleBinResponse(
        images.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def images: Option[List[zio.aws.ec2.model.ImageRecycleBinInfo.ReadOnly]]
    def nextToken: Option[String]
    def getImages: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ImageRecycleBinInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("images", images)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinResponse
  ) extends zio.aws.ec2.model.ListImagesInRecycleBinResponse.ReadOnly {
    override val images
        : Option[List[zio.aws.ec2.model.ImageRecycleBinInfo.ReadOnly]] = scala
      .Option(impl.images())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ImageRecycleBinInfo.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinResponse
  ): zio.aws.ec2.model.ListImagesInRecycleBinResponse.ReadOnly = new Wrapper(
    impl
  )
}
