package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait KeyType {
  def unwrap: software.amazon.awssdk.services.ec2.model.KeyType
}
object KeyType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.KeyType
  ): zio.aws.ec2.model.KeyType = value match {
    case software.amazon.awssdk.services.ec2.model.KeyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.KeyType.RSA =>
      val r = rsa
      r
    case software.amazon.awssdk.services.ec2.model.KeyType.ED25519 =>
      val r = ed25519
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.KeyType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.KeyType =
      software.amazon.awssdk.services.ec2.model.KeyType.UNKNOWN_TO_SDK_VERSION
  }
  case object rsa extends zio.aws.ec2.model.KeyType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.KeyType =
      software.amazon.awssdk.services.ec2.model.KeyType.RSA
  }
  case object ed25519 extends zio.aws.ec2.model.KeyType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.KeyType =
      software.amazon.awssdk.services.ec2.model.KeyType.ED25519
  }
}
