package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  BoxedDouble,
  IpamPoolId,
  IpamScopeId,
  IpamId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class IpamResourceCidr(
    ipamId: Option[IpamId] = None,
    ipamScopeId: Option[IpamScopeId] = None,
    ipamPoolId: Option[IpamPoolId] = None,
    resourceRegion: Option[String] = None,
    resourceOwnerId: Option[String] = None,
    resourceId: Option[String] = None,
    resourceName: Option[String] = None,
    resourceCidr: Option[String] = None,
    resourceType: Option[zio.aws.ec2.model.IpamResourceType] = None,
    resourceTags: Option[Iterable[zio.aws.ec2.model.IpamResourceTag]] = None,
    ipUsage: Option[BoxedDouble] = None,
    complianceStatus: Option[zio.aws.ec2.model.IpamComplianceStatus] = None,
    managementState: Option[zio.aws.ec2.model.IpamManagementState] = None,
    overlapStatus: Option[zio.aws.ec2.model.IpamOverlapStatus] = None,
    vpcId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.IpamResourceCidr = {
    import IpamResourceCidr.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IpamResourceCidr
      .builder()
      .optionallyWith(
        ipamId.map(value => IpamId.unwrap(value): java.lang.String)
      )(_.ipamId)
      .optionallyWith(
        ipamScopeId.map(value => IpamScopeId.unwrap(value): java.lang.String)
      )(_.ipamScopeId)
      .optionallyWith(
        ipamPoolId.map(value => IpamPoolId.unwrap(value): java.lang.String)
      )(_.ipamPoolId)
      .optionallyWith(resourceRegion.map(value => value: java.lang.String))(
        _.resourceRegion
      )
      .optionallyWith(resourceOwnerId.map(value => value: java.lang.String))(
        _.resourceOwnerId
      )
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(resourceName.map(value => value: java.lang.String))(
        _.resourceName
      )
      .optionallyWith(resourceCidr.map(value => value: java.lang.String))(
        _.resourceCidr
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        resourceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceTags)
      .optionallyWith(ipUsage.map(value => value: java.lang.Double))(_.ipUsage)
      .optionallyWith(complianceStatus.map(value => value.unwrap))(
        _.complianceStatus
      )
      .optionallyWith(managementState.map(value => value.unwrap))(
        _.managementState
      )
      .optionallyWith(overlapStatus.map(value => value.unwrap))(_.overlapStatus)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IpamResourceCidr.ReadOnly =
    zio.aws.ec2.model.IpamResourceCidr.wrap(buildAwsValue())
}
object IpamResourceCidr {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.IpamResourceCidr
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IpamResourceCidr =
      zio.aws.ec2.model.IpamResourceCidr(
        ipamId.map(value => value),
        ipamScopeId.map(value => value),
        ipamPoolId.map(value => value),
        resourceRegion.map(value => value),
        resourceOwnerId.map(value => value),
        resourceId.map(value => value),
        resourceName.map(value => value),
        resourceCidr.map(value => value),
        resourceType.map(value => value),
        resourceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipUsage.map(value => value),
        complianceStatus.map(value => value),
        managementState.map(value => value),
        overlapStatus.map(value => value),
        vpcId.map(value => value)
      )
    def ipamId: Option[IpamId]
    def ipamScopeId: Option[IpamScopeId]
    def ipamPoolId: Option[IpamPoolId]
    def resourceRegion: Option[String]
    def resourceOwnerId: Option[String]
    def resourceId: Option[String]
    def resourceName: Option[String]
    def resourceCidr: Option[String]
    def resourceType: Option[zio.aws.ec2.model.IpamResourceType]
    def resourceTags: Option[List[zio.aws.ec2.model.IpamResourceTag.ReadOnly]]
    def ipUsage: Option[BoxedDouble]
    def complianceStatus: Option[zio.aws.ec2.model.IpamComplianceStatus]
    def managementState: Option[zio.aws.ec2.model.IpamManagementState]
    def overlapStatus: Option[zio.aws.ec2.model.IpamOverlapStatus]
    def vpcId: Option[String]
    def getIpamId: ZIO[Any, AwsError, IpamId] =
      AwsError.unwrapOptionField("ipamId", ipamId)
    def getIpamScopeId: ZIO[Any, AwsError, IpamScopeId] =
      AwsError.unwrapOptionField("ipamScopeId", ipamScopeId)
    def getIpamPoolId: ZIO[Any, AwsError, IpamPoolId] =
      AwsError.unwrapOptionField("ipamPoolId", ipamPoolId)
    def getResourceRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceRegion", resourceRegion)
    def getResourceOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceOwnerId", resourceOwnerId)
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceName", resourceName)
    def getResourceCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceCidr", resourceCidr)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceTags
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IpamResourceTag.ReadOnly]] =
      AwsError.unwrapOptionField("resourceTags", resourceTags)
    def getIpUsage: ZIO[Any, AwsError, BoxedDouble] =
      AwsError.unwrapOptionField("ipUsage", ipUsage)
    def getComplianceStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamComplianceStatus] =
      AwsError.unwrapOptionField("complianceStatus", complianceStatus)
    def getManagementState
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamManagementState] =
      AwsError.unwrapOptionField("managementState", managementState)
    def getOverlapStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamOverlapStatus] =
      AwsError.unwrapOptionField("overlapStatus", overlapStatus)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IpamResourceCidr
  ) extends zio.aws.ec2.model.IpamResourceCidr.ReadOnly {
    override val ipamId: Option[IpamId] = scala
      .Option(impl.ipamId())
      .map(value => zio.aws.ec2.model.primitives.IpamId(value))
    override val ipamScopeId: Option[IpamScopeId] = scala
      .Option(impl.ipamScopeId())
      .map(value => zio.aws.ec2.model.primitives.IpamScopeId(value))
    override val ipamPoolId: Option[IpamPoolId] = scala
      .Option(impl.ipamPoolId())
      .map(value => zio.aws.ec2.model.primitives.IpamPoolId(value))
    override val resourceRegion: Option[String] =
      scala.Option(impl.resourceRegion()).map(value => value: String)
    override val resourceOwnerId: Option[String] =
      scala.Option(impl.resourceOwnerId()).map(value => value: String)
    override val resourceId: Option[String] =
      scala.Option(impl.resourceId()).map(value => value: String)
    override val resourceName: Option[String] =
      scala.Option(impl.resourceName()).map(value => value: String)
    override val resourceCidr: Option[String] =
      scala.Option(impl.resourceCidr()).map(value => value: String)
    override val resourceType: Option[zio.aws.ec2.model.IpamResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value => zio.aws.ec2.model.IpamResourceType.wrap(value))
    override val resourceTags
        : Option[List[zio.aws.ec2.model.IpamResourceTag.ReadOnly]] = scala
      .Option(impl.resourceTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.IpamResourceTag.wrap(item)
        }.toList
      )
    override val ipUsage: Option[BoxedDouble] =
      scala.Option(impl.ipUsage()).map(value => value: BoxedDouble)
    override val complianceStatus
        : Option[zio.aws.ec2.model.IpamComplianceStatus] = scala
      .Option(impl.complianceStatus())
      .map(value => zio.aws.ec2.model.IpamComplianceStatus.wrap(value))
    override val managementState
        : Option[zio.aws.ec2.model.IpamManagementState] = scala
      .Option(impl.managementState())
      .map(value => zio.aws.ec2.model.IpamManagementState.wrap(value))
    override val overlapStatus: Option[zio.aws.ec2.model.IpamOverlapStatus] =
      scala
        .Option(impl.overlapStatus())
        .map(value => zio.aws.ec2.model.IpamOverlapStatus.wrap(value))
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IpamResourceCidr
  ): zio.aws.ec2.model.IpamResourceCidr.ReadOnly = new Wrapper(impl)
}
