package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  TransitGatewayMaxResults,
  TransitGatewayMulticastDomainId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetTransitGatewayMulticastDomainAssociationsRequest(
    transitGatewayMulticastDomainId: Option[TransitGatewayMulticastDomainId] =
      None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[TransitGatewayMaxResults] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetTransitGatewayMulticastDomainAssociationsRequest = {
    import GetTransitGatewayMulticastDomainAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetTransitGatewayMulticastDomainAssociationsRequest
      .builder()
      .optionallyWith(
        transitGatewayMulticastDomainId.map(value =>
          TransitGatewayMulticastDomainId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayMulticastDomainId)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => TransitGatewayMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetTransitGatewayMulticastDomainAssociationsRequest.ReadOnly =
    zio.aws.ec2.model.GetTransitGatewayMulticastDomainAssociationsRequest
      .wrap(buildAwsValue())
}
object GetTransitGatewayMulticastDomainAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetTransitGatewayMulticastDomainAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.GetTransitGatewayMulticastDomainAssociationsRequest =
      zio.aws.ec2.model.GetTransitGatewayMulticastDomainAssociationsRequest(
        transitGatewayMulticastDomainId.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def transitGatewayMulticastDomainId: Option[TransitGatewayMulticastDomainId]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[TransitGatewayMaxResults]
    def nextToken: Option[String]
    def getTransitGatewayMulticastDomainId
        : ZIO[Any, AwsError, TransitGatewayMulticastDomainId] =
      AwsError.unwrapOptionField(
        "transitGatewayMulticastDomainId",
        transitGatewayMulticastDomainId
      )
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, TransitGatewayMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetTransitGatewayMulticastDomainAssociationsRequest
  ) extends zio.aws.ec2.model.GetTransitGatewayMulticastDomainAssociationsRequest.ReadOnly {
    override val transitGatewayMulticastDomainId
        : Option[TransitGatewayMulticastDomainId] = scala
      .Option(impl.transitGatewayMulticastDomainId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayMulticastDomainId(value)
      )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[TransitGatewayMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayMaxResults(value)
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetTransitGatewayMulticastDomainAssociationsRequest
  ): zio.aws.ec2.model.GetTransitGatewayMulticastDomainAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
