package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetEbsDefaultKmsKeyIdResponse(
    kmsKeyId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetEbsDefaultKmsKeyIdResponse = {
    import GetEbsDefaultKmsKeyIdResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetEbsDefaultKmsKeyIdResponse
      .builder()
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetEbsDefaultKmsKeyIdResponse.ReadOnly =
    zio.aws.ec2.model.GetEbsDefaultKmsKeyIdResponse.wrap(buildAwsValue())
}
object GetEbsDefaultKmsKeyIdResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetEbsDefaultKmsKeyIdResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetEbsDefaultKmsKeyIdResponse =
      zio.aws.ec2.model
        .GetEbsDefaultKmsKeyIdResponse(kmsKeyId.map(value => value))
    def kmsKeyId: Option[String]
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetEbsDefaultKmsKeyIdResponse
  ) extends zio.aws.ec2.model.GetEbsDefaultKmsKeyIdResponse.ReadOnly {
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetEbsDefaultKmsKeyIdResponse
  ): zio.aws.ec2.model.GetEbsDefaultKmsKeyIdResponse.ReadOnly = new Wrapper(
    impl
  )
}
