package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  FpgaDeviceCount,
  FpgaDeviceManufacturerName,
  FpgaDeviceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FpgaDeviceInfo(
    name: Option[FpgaDeviceName] = None,
    manufacturer: Option[FpgaDeviceManufacturerName] = None,
    count: Option[FpgaDeviceCount] = None,
    memoryInfo: Option[zio.aws.ec2.model.FpgaDeviceMemoryInfo] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FpgaDeviceInfo = {
    import FpgaDeviceInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FpgaDeviceInfo
      .builder()
      .optionallyWith(
        name.map(value => FpgaDeviceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        manufacturer.map(value =>
          FpgaDeviceManufacturerName.unwrap(value): java.lang.String
        )
      )(_.manufacturer)
      .optionallyWith(
        count.map(value => FpgaDeviceCount.unwrap(value): Integer)
      )(_.count)
      .optionallyWith(memoryInfo.map(value => value.buildAwsValue()))(
        _.memoryInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FpgaDeviceInfo.ReadOnly =
    zio.aws.ec2.model.FpgaDeviceInfo.wrap(buildAwsValue())
}
object FpgaDeviceInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FpgaDeviceInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FpgaDeviceInfo =
      zio.aws.ec2.model.FpgaDeviceInfo(
        name.map(value => value),
        manufacturer.map(value => value),
        count.map(value => value),
        memoryInfo.map(value => value.asEditable)
      )
    def name: Option[FpgaDeviceName]
    def manufacturer: Option[FpgaDeviceManufacturerName]
    def count: Option[FpgaDeviceCount]
    def memoryInfo: Option[zio.aws.ec2.model.FpgaDeviceMemoryInfo.ReadOnly]
    def getName: ZIO[Any, AwsError, FpgaDeviceName] =
      AwsError.unwrapOptionField("name", name)
    def getManufacturer: ZIO[Any, AwsError, FpgaDeviceManufacturerName] =
      AwsError.unwrapOptionField("manufacturer", manufacturer)
    def getCount: ZIO[Any, AwsError, FpgaDeviceCount] =
      AwsError.unwrapOptionField("count", count)
    def getMemoryInfo
        : ZIO[Any, AwsError, zio.aws.ec2.model.FpgaDeviceMemoryInfo.ReadOnly] =
      AwsError.unwrapOptionField("memoryInfo", memoryInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FpgaDeviceInfo
  ) extends zio.aws.ec2.model.FpgaDeviceInfo.ReadOnly {
    override val name: Option[FpgaDeviceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ec2.model.primitives.FpgaDeviceName(value))
    override val manufacturer: Option[FpgaDeviceManufacturerName] = scala
      .Option(impl.manufacturer())
      .map(value =>
        zio.aws.ec2.model.primitives.FpgaDeviceManufacturerName(value)
      )
    override val count: Option[FpgaDeviceCount] = scala
      .Option(impl.count())
      .map(value => zio.aws.ec2.model.primitives.FpgaDeviceCount(value))
    override val memoryInfo
        : Option[zio.aws.ec2.model.FpgaDeviceMemoryInfo.ReadOnly] = scala
      .Option(impl.memoryInfo())
      .map(value => zio.aws.ec2.model.FpgaDeviceMemoryInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FpgaDeviceInfo
  ): zio.aws.ec2.model.FpgaDeviceInfo.ReadOnly = new Wrapper(impl)
}
