package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FleetSpotMaintenanceStrategiesRequest(
    capacityRebalance: Option[
      zio.aws.ec2.model.FleetSpotCapacityRebalanceRequest
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FleetSpotMaintenanceStrategiesRequest = {
    import FleetSpotMaintenanceStrategiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FleetSpotMaintenanceStrategiesRequest
      .builder()
      .optionallyWith(capacityRebalance.map(value => value.buildAwsValue()))(
        _.capacityRebalance
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.FleetSpotMaintenanceStrategiesRequest.ReadOnly =
    zio.aws.ec2.model.FleetSpotMaintenanceStrategiesRequest
      .wrap(buildAwsValue())
}
object FleetSpotMaintenanceStrategiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FleetSpotMaintenanceStrategiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FleetSpotMaintenanceStrategiesRequest =
      zio.aws.ec2.model.FleetSpotMaintenanceStrategiesRequest(
        capacityRebalance.map(value => value.asEditable)
      )
    def capacityRebalance
        : Option[zio.aws.ec2.model.FleetSpotCapacityRebalanceRequest.ReadOnly]
    def getCapacityRebalance: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FleetSpotCapacityRebalanceRequest.ReadOnly
    ] = AwsError.unwrapOptionField("capacityRebalance", capacityRebalance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FleetSpotMaintenanceStrategiesRequest
  ) extends zio.aws.ec2.model.FleetSpotMaintenanceStrategiesRequest.ReadOnly {
    override val capacityRebalance
        : Option[zio.aws.ec2.model.FleetSpotCapacityRebalanceRequest.ReadOnly] =
      scala
        .Option(impl.capacityRebalance())
        .map(value =>
          zio.aws.ec2.model.FleetSpotCapacityRebalanceRequest.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FleetSpotMaintenanceStrategiesRequest
  ): zio.aws.ec2.model.FleetSpotMaintenanceStrategiesRequest.ReadOnly =
    new Wrapper(impl)
}
