package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExportToS3Task(
    containerFormat: Option[zio.aws.ec2.model.ContainerFormat] = None,
    diskImageFormat: Option[zio.aws.ec2.model.DiskImageFormat] = None,
    s3Bucket: Option[String] = None,
    s3Key: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ExportToS3Task = {
    import ExportToS3Task.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ExportToS3Task
      .builder()
      .optionallyWith(containerFormat.map(value => value.unwrap))(
        _.containerFormat
      )
      .optionallyWith(diskImageFormat.map(value => value.unwrap))(
        _.diskImageFormat
      )
      .optionallyWith(s3Bucket.map(value => value: java.lang.String))(
        _.s3Bucket
      )
      .optionallyWith(s3Key.map(value => value: java.lang.String))(_.s3Key)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ExportToS3Task.ReadOnly =
    zio.aws.ec2.model.ExportToS3Task.wrap(buildAwsValue())
}
object ExportToS3Task {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ExportToS3Task
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ExportToS3Task =
      zio.aws.ec2.model.ExportToS3Task(
        containerFormat.map(value => value),
        diskImageFormat.map(value => value),
        s3Bucket.map(value => value),
        s3Key.map(value => value)
      )
    def containerFormat: Option[zio.aws.ec2.model.ContainerFormat]
    def diskImageFormat: Option[zio.aws.ec2.model.DiskImageFormat]
    def s3Bucket: Option[String]
    def s3Key: Option[String]
    def getContainerFormat
        : ZIO[Any, AwsError, zio.aws.ec2.model.ContainerFormat] =
      AwsError.unwrapOptionField("containerFormat", containerFormat)
    def getDiskImageFormat
        : ZIO[Any, AwsError, zio.aws.ec2.model.DiskImageFormat] =
      AwsError.unwrapOptionField("diskImageFormat", diskImageFormat)
    def getS3Bucket: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3Key: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3Key", s3Key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ExportToS3Task
  ) extends zio.aws.ec2.model.ExportToS3Task.ReadOnly {
    override val containerFormat: Option[zio.aws.ec2.model.ContainerFormat] =
      scala
        .Option(impl.containerFormat())
        .map(value => zio.aws.ec2.model.ContainerFormat.wrap(value))
    override val diskImageFormat: Option[zio.aws.ec2.model.DiskImageFormat] =
      scala
        .Option(impl.diskImageFormat())
        .map(value => zio.aws.ec2.model.DiskImageFormat.wrap(value))
    override val s3Bucket: Option[String] =
      scala.Option(impl.s3Bucket()).map(value => value: String)
    override val s3Key: Option[String] =
      scala.Option(impl.s3Key()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ExportToS3Task
  ): zio.aws.ec2.model.ExportToS3Task.ReadOnly = new Wrapper(impl)
}
