package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DisassociateTransitGatewayMulticastDomainResponse(
    associations: Option[
      zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayMulticastDomainResponse = {
    import DisassociateTransitGatewayMulticastDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayMulticastDomainResponse
      .builder()
      .optionallyWith(associations.map(value => value.buildAwsValue()))(
        _.associations
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisassociateTransitGatewayMulticastDomainResponse.ReadOnly =
    zio.aws.ec2.model.DisassociateTransitGatewayMulticastDomainResponse
      .wrap(buildAwsValue())
}
object DisassociateTransitGatewayMulticastDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayMulticastDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DisassociateTransitGatewayMulticastDomainResponse =
      zio.aws.ec2.model.DisassociateTransitGatewayMulticastDomainResponse(
        associations.map(value => value.asEditable)
      )
    def associations: Option[
      zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations.ReadOnly
    ]
    def getAssociations: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations.ReadOnly
    ] = AwsError.unwrapOptionField("associations", associations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayMulticastDomainResponse
  ) extends zio.aws.ec2.model.DisassociateTransitGatewayMulticastDomainResponse.ReadOnly {
    override val associations: Option[
      zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations.ReadOnly
    ] = scala
      .Option(impl.associations())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayMulticastDomainResponse
  ): zio.aws.ec2.model.DisassociateTransitGatewayMulticastDomainResponse.ReadOnly =
    new Wrapper(impl)
}
