package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, VpcEndpointServiceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeVpcEndpointServicePermissionsRequest(
    serviceId: VpcEndpointServiceId,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsRequest = {
    import DescribeVpcEndpointServicePermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsRequest
      .builder()
      .serviceId(VpcEndpointServiceId.unwrap(serviceId): java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsRequest
      .wrap(buildAwsValue())
}
object DescribeVpcEndpointServicePermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsRequest =
      zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsRequest(
        serviceId,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def serviceId: VpcEndpointServiceId
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def getServiceId: ZIO[Any, Nothing, VpcEndpointServiceId] =
      ZIO.succeed(serviceId)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsRequest
  ) extends zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsRequest.ReadOnly {
    override val serviceId: VpcEndpointServiceId =
      zio.aws.ec2.model.primitives.VpcEndpointServiceId(impl.serviceId())
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[Integer] =
      scala.Option(impl.maxResults()).map(value => value: Integer)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsRequest
  ): zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsRequest.ReadOnly =
    new Wrapper(impl)
}
