package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeVpcAttributeRequest(
    attribute: zio.aws.ec2.model.VpcAttributeName,
    vpcId: VpcId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeRequest = {
    import DescribeVpcAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeRequest
      .builder()
      .attribute(attribute.unwrap)
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeVpcAttributeRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVpcAttributeRequest.wrap(buildAwsValue())
}
object DescribeVpcAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVpcAttributeRequest =
      zio.aws.ec2.model.DescribeVpcAttributeRequest(attribute, vpcId)
    def attribute: zio.aws.ec2.model.VpcAttributeName
    def vpcId: VpcId
    def getAttribute: ZIO[Any, Nothing, zio.aws.ec2.model.VpcAttributeName] =
      ZIO.succeed(attribute)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeRequest
  ) extends zio.aws.ec2.model.DescribeVpcAttributeRequest.ReadOnly {
    override val attribute: zio.aws.ec2.model.VpcAttributeName =
      zio.aws.ec2.model.VpcAttributeName.wrap(impl.attribute())
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeRequest
  ): zio.aws.ec2.model.DescribeVpcAttributeRequest.ReadOnly = new Wrapper(impl)
}
