package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  DescribeTrunkInterfaceAssociationsMaxResults,
  TrunkInterfaceAssociationId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeTrunkInterfaceAssociationsRequest(
    associationIds: Option[Iterable[TrunkInterfaceAssociationId]] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    nextToken: Option[String] = None,
    maxResults: Option[DescribeTrunkInterfaceAssociationsMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsRequest = {
    import DescribeTrunkInterfaceAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsRequest
      .builder()
      .optionallyWith(
        associationIds.map(value =>
          value.map { item =>
            TrunkInterfaceAssociationId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.associationIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeTrunkInterfaceAssociationsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsRequest
      .wrap(buildAwsValue())
}
object DescribeTrunkInterfaceAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsRequest =
      zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsRequest(
        associationIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def associationIds: Option[List[TrunkInterfaceAssociationId]]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def nextToken: Option[String]
    def maxResults: Option[DescribeTrunkInterfaceAssociationsMaxResults]
    def getAssociationIds
        : ZIO[Any, AwsError, List[TrunkInterfaceAssociationId]] =
      AwsError.unwrapOptionField("associationIds", associationIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeTrunkInterfaceAssociationsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsRequest
  ) extends zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsRequest.ReadOnly {
    override val associationIds: Option[List[TrunkInterfaceAssociationId]] =
      scala
        .Option(impl.associationIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.TrunkInterfaceAssociationId(item)
          }.toList
        )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults
        : Option[DescribeTrunkInterfaceAssociationsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives
          .DescribeTrunkInterfaceAssociationsMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsRequest
  ): zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
