package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeTrafficMirrorTargetsResponse(
    trafficMirrorTargets: Option[
      Iterable[zio.aws.ec2.model.TrafficMirrorTarget]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorTargetsResponse = {
    import DescribeTrafficMirrorTargetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorTargetsResponse
      .builder()
      .optionallyWith(
        trafficMirrorTargets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.trafficMirrorTargets)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeTrafficMirrorTargetsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeTrafficMirrorTargetsResponse.wrap(buildAwsValue())
}
object DescribeTrafficMirrorTargetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorTargetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeTrafficMirrorTargetsResponse =
      zio.aws.ec2.model.DescribeTrafficMirrorTargetsResponse(
        trafficMirrorTargets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def trafficMirrorTargets
        : Option[List[zio.aws.ec2.model.TrafficMirrorTarget.ReadOnly]]
    def nextToken: Option[String]
    def getTrafficMirrorTargets: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TrafficMirrorTarget.ReadOnly
    ]] =
      AwsError.unwrapOptionField("trafficMirrorTargets", trafficMirrorTargets)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorTargetsResponse
  ) extends zio.aws.ec2.model.DescribeTrafficMirrorTargetsResponse.ReadOnly {
    override val trafficMirrorTargets
        : Option[List[zio.aws.ec2.model.TrafficMirrorTarget.ReadOnly]] = scala
      .Option(impl.trafficMirrorTargets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TrafficMirrorTarget.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorTargetsResponse
  ): zio.aws.ec2.model.DescribeTrafficMirrorTargetsResponse.ReadOnly =
    new Wrapper(impl)
}
