package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribePrefixListsResponse(
    nextToken: Option[String] = None,
    prefixLists: Option[Iterable[zio.aws.ec2.model.PrefixList]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribePrefixListsResponse = {
    import DescribePrefixListsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribePrefixListsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        prefixLists.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.prefixLists)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribePrefixListsResponse.ReadOnly =
    zio.aws.ec2.model.DescribePrefixListsResponse.wrap(buildAwsValue())
}
object DescribePrefixListsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribePrefixListsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribePrefixListsResponse =
      zio.aws.ec2.model.DescribePrefixListsResponse(
        nextToken.map(value => value),
        prefixLists.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[String]
    def prefixLists: Option[List[zio.aws.ec2.model.PrefixList.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPrefixLists
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PrefixList.ReadOnly]] =
      AwsError.unwrapOptionField("prefixLists", prefixLists)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribePrefixListsResponse
  ) extends zio.aws.ec2.model.DescribePrefixListsResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val prefixLists
        : Option[List[zio.aws.ec2.model.PrefixList.ReadOnly]] = scala
      .Option(impl.prefixLists())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.PrefixList.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribePrefixListsResponse
  ): zio.aws.ec2.model.DescribePrefixListsResponse.ReadOnly = new Wrapper(impl)
}
