package zio.aws.ec2.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  NetworkInsightsAccessScopeAnalysisId,
  MillisecondDateTime,
  NetworkInsightsMaxResults,
  NetworkInsightsAccessScopeId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeNetworkInsightsAccessScopeAnalysesRequest(
    networkInsightsAccessScopeAnalysisIds: Option[
      Iterable[NetworkInsightsAccessScopeAnalysisId]
    ] = None,
    networkInsightsAccessScopeId: Option[NetworkInsightsAccessScopeId] = None,
    analysisStartTimeBegin: Option[MillisecondDateTime] = None,
    analysisStartTimeEnd: Option[MillisecondDateTime] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[NetworkInsightsMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest = {
    import DescribeNetworkInsightsAccessScopeAnalysesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest
      .builder()
      .optionallyWith(
        networkInsightsAccessScopeAnalysisIds.map(value =>
          value.map { item =>
            NetworkInsightsAccessScopeAnalysisId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.networkInsightsAccessScopeAnalysisIds)
      .optionallyWith(
        networkInsightsAccessScopeId.map(value =>
          NetworkInsightsAccessScopeId.unwrap(value): java.lang.String
        )
      )(_.networkInsightsAccessScopeId)
      .optionallyWith(
        analysisStartTimeBegin.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.analysisStartTimeBegin)
      .optionallyWith(
        analysisStartTimeEnd.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.analysisStartTimeEnd)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          NetworkInsightsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest
      .wrap(buildAwsValue())
}
object DescribeNetworkInsightsAccessScopeAnalysesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest =
      zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest(
        networkInsightsAccessScopeAnalysisIds.map(value => value),
        networkInsightsAccessScopeId.map(value => value),
        analysisStartTimeBegin.map(value => value),
        analysisStartTimeEnd.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def networkInsightsAccessScopeAnalysisIds
        : Option[List[NetworkInsightsAccessScopeAnalysisId]]
    def networkInsightsAccessScopeId: Option[NetworkInsightsAccessScopeId]
    def analysisStartTimeBegin: Option[MillisecondDateTime]
    def analysisStartTimeEnd: Option[MillisecondDateTime]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[NetworkInsightsMaxResults]
    def nextToken: Option[NextToken]
    def getNetworkInsightsAccessScopeAnalysisIds
        : ZIO[Any, AwsError, List[NetworkInsightsAccessScopeAnalysisId]] =
      AwsError.unwrapOptionField(
        "networkInsightsAccessScopeAnalysisIds",
        networkInsightsAccessScopeAnalysisIds
      )
    def getNetworkInsightsAccessScopeId
        : ZIO[Any, AwsError, NetworkInsightsAccessScopeId] =
      AwsError.unwrapOptionField(
        "networkInsightsAccessScopeId",
        networkInsightsAccessScopeId
      )
    def getAnalysisStartTimeBegin: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField(
        "analysisStartTimeBegin",
        analysisStartTimeBegin
      )
    def getAnalysisStartTimeEnd: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("analysisStartTimeEnd", analysisStartTimeEnd)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, NetworkInsightsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest
  ) extends zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest.ReadOnly {
    override val networkInsightsAccessScopeAnalysisIds
        : Option[List[NetworkInsightsAccessScopeAnalysisId]] = scala
      .Option(impl.networkInsightsAccessScopeAnalysisIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives
            .NetworkInsightsAccessScopeAnalysisId(item)
        }.toList
      )
    override val networkInsightsAccessScopeId
        : Option[NetworkInsightsAccessScopeId] = scala
      .Option(impl.networkInsightsAccessScopeId())
      .map(value =>
        zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeId(value)
      )
    override val analysisStartTimeBegin: Option[MillisecondDateTime] = scala
      .Option(impl.analysisStartTimeBegin())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val analysisStartTimeEnd: Option[MillisecondDateTime] = scala
      .Option(impl.analysisStartTimeEnd())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[NetworkInsightsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.NetworkInsightsMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest
  ): zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest.ReadOnly =
    new Wrapper(impl)
}
