package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.DescribeMovingAddressesMaxResults
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeMovingAddressesRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[DescribeMovingAddressesMaxResults] = None,
    nextToken: Option[String] = None,
    publicIps: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesRequest = {
    import DescribeMovingAddressesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          DescribeMovingAddressesMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        publicIps.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.publicIps)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeMovingAddressesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeMovingAddressesRequest.wrap(buildAwsValue())
}
object DescribeMovingAddressesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeMovingAddressesRequest =
      zio.aws.ec2.model.DescribeMovingAddressesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value),
        publicIps.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[DescribeMovingAddressesMaxResults]
    def nextToken: Option[String]
    def publicIps: Option[List[String]]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, DescribeMovingAddressesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPublicIps: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("publicIps", publicIps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesRequest
  ) extends zio.aws.ec2.model.DescribeMovingAddressesRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[DescribeMovingAddressesMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.DescribeMovingAddressesMaxResults(value)
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val publicIps: Option[List[String]] = scala
      .Option(impl.publicIps())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesRequest
  ): zio.aws.ec2.model.DescribeMovingAddressesRequest.ReadOnly = new Wrapper(
    impl
  )
}
