package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, InstanceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeInstanceStatusRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    instanceIds: Option[Iterable[InstanceId]] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None,
    includeAllInstances: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest = {
    import DescribeInstanceStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        instanceIds.map(value =>
          value.map { item =>
            InstanceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceIds)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        includeAllInstances.map(value => value: java.lang.Boolean)
      )(_.includeAllInstances)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeInstanceStatusRequest.ReadOnly =
    zio.aws.ec2.model.DescribeInstanceStatusRequest.wrap(buildAwsValue())
}
object DescribeInstanceStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeInstanceStatusRequest =
      zio.aws.ec2.model.DescribeInstanceStatusRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        includeAllInstances.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def instanceIds: Option[List[InstanceId]]
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def includeAllInstances: Option[Boolean]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getInstanceIds: ZIO[Any, AwsError, List[InstanceId]] =
      AwsError.unwrapOptionField("instanceIds", instanceIds)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getIncludeAllInstances: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeAllInstances", includeAllInstances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest
  ) extends zio.aws.ec2.model.DescribeInstanceStatusRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val instanceIds: Option[List[InstanceId]] = scala
      .Option(impl.instanceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.InstanceId(item)
        }.toList
      )
    override val maxResults: Option[Integer] =
      scala.Option(impl.maxResults()).map(value => value: Integer)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val includeAllInstances: Option[Boolean] =
      scala.Option(impl.includeAllInstances()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest
  ): zio.aws.ec2.model.DescribeInstanceStatusRequest.ReadOnly = new Wrapper(
    impl
  )
}
