package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeClientVpnTargetNetworksResponse(
    clientVpnTargetNetworks: Option[Iterable[zio.aws.ec2.model.TargetNetwork]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksResponse = {
    import DescribeClientVpnTargetNetworksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksResponse
      .builder()
      .optionallyWith(
        clientVpnTargetNetworks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clientVpnTargetNetworks)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeClientVpnTargetNetworksResponse.ReadOnly =
    zio.aws.ec2.model.DescribeClientVpnTargetNetworksResponse
      .wrap(buildAwsValue())
}
object DescribeClientVpnTargetNetworksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeClientVpnTargetNetworksResponse =
      zio.aws.ec2.model.DescribeClientVpnTargetNetworksResponse(
        clientVpnTargetNetworks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def clientVpnTargetNetworks
        : Option[List[zio.aws.ec2.model.TargetNetwork.ReadOnly]]
    def nextToken: Option[NextToken]
    def getClientVpnTargetNetworks
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.TargetNetwork.ReadOnly]] =
      AwsError.unwrapOptionField(
        "clientVpnTargetNetworks",
        clientVpnTargetNetworks
      )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksResponse
  ) extends zio.aws.ec2.model.DescribeClientVpnTargetNetworksResponse.ReadOnly {
    override val clientVpnTargetNetworks
        : Option[List[zio.aws.ec2.model.TargetNetwork.ReadOnly]] = scala
      .Option(impl.clientVpnTargetNetworks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TargetNetwork.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksResponse
  ): zio.aws.ec2.model.DescribeClientVpnTargetNetworksResponse.ReadOnly =
    new Wrapper(impl)
}
