package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeClientVpnEndpointsResponse(
    clientVpnEndpoints: Option[Iterable[zio.aws.ec2.model.ClientVpnEndpoint]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsResponse = {
    import DescribeClientVpnEndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsResponse
      .builder()
      .optionallyWith(
        clientVpnEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clientVpnEndpoints)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeClientVpnEndpointsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeClientVpnEndpointsResponse.wrap(buildAwsValue())
}
object DescribeClientVpnEndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeClientVpnEndpointsResponse =
      zio.aws.ec2.model.DescribeClientVpnEndpointsResponse(
        clientVpnEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def clientVpnEndpoints
        : Option[List[zio.aws.ec2.model.ClientVpnEndpoint.ReadOnly]]
    def nextToken: Option[NextToken]
    def getClientVpnEndpoints: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ClientVpnEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("clientVpnEndpoints", clientVpnEndpoints)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsResponse
  ) extends zio.aws.ec2.model.DescribeClientVpnEndpointsResponse.ReadOnly {
    override val clientVpnEndpoints
        : Option[List[zio.aws.ec2.model.ClientVpnEndpoint.ReadOnly]] = scala
      .Option(impl.clientVpnEndpoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ClientVpnEndpoint.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsResponse
  ): zio.aws.ec2.model.DescribeClientVpnEndpointsResponse.ReadOnly =
    new Wrapper(impl)
}
