package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.PlacementGroupName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeletePlacementGroupRequest(groupName: PlacementGroupName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeletePlacementGroupRequest = {
    import DeletePlacementGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeletePlacementGroupRequest
      .builder()
      .groupName(PlacementGroupName.unwrap(groupName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeletePlacementGroupRequest.ReadOnly =
    zio.aws.ec2.model.DeletePlacementGroupRequest.wrap(buildAwsValue())
}
object DeletePlacementGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeletePlacementGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeletePlacementGroupRequest =
      zio.aws.ec2.model.DeletePlacementGroupRequest(groupName)
    def groupName: PlacementGroupName
    def getGroupName: ZIO[Any, Nothing, PlacementGroupName] =
      ZIO.succeed(groupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeletePlacementGroupRequest
  ) extends zio.aws.ec2.model.DeletePlacementGroupRequest.ReadOnly {
    override val groupName: PlacementGroupName =
      zio.aws.ec2.model.primitives.PlacementGroupName(impl.groupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeletePlacementGroupRequest
  ): zio.aws.ec2.model.DeletePlacementGroupRequest.ReadOnly = new Wrapper(impl)
}
