package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteLocalGatewayRouteResponse(
    route: Option[zio.aws.ec2.model.LocalGatewayRoute] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteResponse = {
    import DeleteLocalGatewayRouteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteResponse
      .builder()
      .optionallyWith(route.map(value => value.buildAwsValue()))(_.route)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteLocalGatewayRouteResponse.ReadOnly =
    zio.aws.ec2.model.DeleteLocalGatewayRouteResponse.wrap(buildAwsValue())
}
object DeleteLocalGatewayRouteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteLocalGatewayRouteResponse =
      zio.aws.ec2.model
        .DeleteLocalGatewayRouteResponse(route.map(value => value.asEditable))
    def route: Option[zio.aws.ec2.model.LocalGatewayRoute.ReadOnly]
    def getRoute
        : ZIO[Any, AwsError, zio.aws.ec2.model.LocalGatewayRoute.ReadOnly] =
      AwsError.unwrapOptionField("route", route)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteResponse
  ) extends zio.aws.ec2.model.DeleteLocalGatewayRouteResponse.ReadOnly {
    override val route: Option[zio.aws.ec2.model.LocalGatewayRoute.ReadOnly] =
      scala
        .Option(impl.route())
        .map(value => zio.aws.ec2.model.LocalGatewayRoute.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteResponse
  ): zio.aws.ec2.model.DeleteLocalGatewayRouteResponse.ReadOnly = new Wrapper(
    impl
  )
}
