package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IpamId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteIpamRequest(
    ipamId: IpamId,
    cascade: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteIpamRequest = {
    import DeleteIpamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteIpamRequest
      .builder()
      .ipamId(IpamId.unwrap(ipamId): java.lang.String)
      .optionallyWith(cascade.map(value => value: java.lang.Boolean))(_.cascade)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteIpamRequest.ReadOnly =
    zio.aws.ec2.model.DeleteIpamRequest.wrap(buildAwsValue())
}
object DeleteIpamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteIpamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteIpamRequest =
      zio.aws.ec2.model.DeleteIpamRequest(ipamId, cascade.map(value => value))
    def ipamId: IpamId
    def cascade: Option[Boolean]
    def getIpamId: ZIO[Any, Nothing, IpamId] = ZIO.succeed(ipamId)
    def getCascade: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("cascade", cascade)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteIpamRequest
  ) extends zio.aws.ec2.model.DeleteIpamRequest.ReadOnly {
    override val ipamId: IpamId =
      zio.aws.ec2.model.primitives.IpamId(impl.ipamId())
    override val cascade: Option[Boolean] =
      scala.Option(impl.cascade()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteIpamRequest
  ): zio.aws.ec2.model.DeleteIpamRequest.ReadOnly = new Wrapper(impl)
}
