package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateVolumePermissionModifications(
    add: Option[Iterable[zio.aws.ec2.model.CreateVolumePermission]] = None,
    remove: Option[Iterable[zio.aws.ec2.model.CreateVolumePermission]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVolumePermissionModifications = {
    import CreateVolumePermissionModifications.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVolumePermissionModifications
      .builder()
      .optionallyWith(
        add.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.add)
      .optionallyWith(
        remove.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.remove)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateVolumePermissionModifications.ReadOnly =
    zio.aws.ec2.model.CreateVolumePermissionModifications.wrap(buildAwsValue())
}
object CreateVolumePermissionModifications {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVolumePermissionModifications
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVolumePermissionModifications =
      zio.aws.ec2.model.CreateVolumePermissionModifications(
        add.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        remove.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def add: Option[List[zio.aws.ec2.model.CreateVolumePermission.ReadOnly]]
    def remove: Option[List[zio.aws.ec2.model.CreateVolumePermission.ReadOnly]]
    def getAdd: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.CreateVolumePermission.ReadOnly
    ]] = AwsError.unwrapOptionField("add", add)
    def getRemove: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.CreateVolumePermission.ReadOnly
    ]] = AwsError.unwrapOptionField("remove", remove)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVolumePermissionModifications
  ) extends zio.aws.ec2.model.CreateVolumePermissionModifications.ReadOnly {
    override val add
        : Option[List[zio.aws.ec2.model.CreateVolumePermission.ReadOnly]] =
      scala
        .Option(impl.add())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.CreateVolumePermission.wrap(item)
          }.toList
        )
    override val remove
        : Option[List[zio.aws.ec2.model.CreateVolumePermission.ReadOnly]] =
      scala
        .Option(impl.remove())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.CreateVolumePermission.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVolumePermissionModifications
  ): zio.aws.ec2.model.CreateVolumePermissionModifications.ReadOnly =
    new Wrapper(impl)
}
