package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateVolumePermission(
    group: Option[zio.aws.ec2.model.PermissionGroup] = None,
    userId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVolumePermission = {
    import CreateVolumePermission.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVolumePermission
      .builder()
      .optionallyWith(group.map(value => value.unwrap))(_.group)
      .optionallyWith(userId.map(value => value: java.lang.String))(_.userId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateVolumePermission.ReadOnly =
    zio.aws.ec2.model.CreateVolumePermission.wrap(buildAwsValue())
}
object CreateVolumePermission {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVolumePermission
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVolumePermission =
      zio.aws.ec2.model.CreateVolumePermission(
        group.map(value => value),
        userId.map(value => value)
      )
    def group: Option[zio.aws.ec2.model.PermissionGroup]
    def userId: Option[String]
    def getGroup: ZIO[Any, AwsError, zio.aws.ec2.model.PermissionGroup] =
      AwsError.unwrapOptionField("group", group)
    def getUserId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userId", userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVolumePermission
  ) extends zio.aws.ec2.model.CreateVolumePermission.ReadOnly {
    override val group: Option[zio.aws.ec2.model.PermissionGroup] = scala
      .Option(impl.group())
      .map(value => zio.aws.ec2.model.PermissionGroup.wrap(value))
    override val userId: Option[String] =
      scala.Option(impl.userId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVolumePermission
  ): zio.aws.ec2.model.CreateVolumePermission.ReadOnly = new Wrapper(impl)
}
