package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateSnapshotsResponse(
    snapshots: Option[Iterable[zio.aws.ec2.model.SnapshotInfo]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateSnapshotsResponse = {
    import CreateSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateSnapshotsResponse
      .builder()
      .optionallyWith(
        snapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.snapshots)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateSnapshotsResponse.ReadOnly =
    zio.aws.ec2.model.CreateSnapshotsResponse.wrap(buildAwsValue())
}
object CreateSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateSnapshotsResponse =
      zio.aws.ec2.model.CreateSnapshotsResponse(
        snapshots.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def snapshots: Option[List[zio.aws.ec2.model.SnapshotInfo.ReadOnly]]
    def getSnapshots
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.SnapshotInfo.ReadOnly]] =
      AwsError.unwrapOptionField("snapshots", snapshots)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateSnapshotsResponse
  ) extends zio.aws.ec2.model.CreateSnapshotsResponse.ReadOnly {
    override val snapshots
        : Option[List[zio.aws.ec2.model.SnapshotInfo.ReadOnly]] = scala
      .Option(impl.snapshots())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.SnapshotInfo.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateSnapshotsResponse
  ): zio.aws.ec2.model.CreateSnapshotsResponse.ReadOnly = new Wrapper(impl)
}
